<?php

class MeowPWA_Admin {
    public function init() {
        add_action('admin_menu', array($this, 'add_menu_page'));
        add_action('admin_init', array($this, 'register_settings'));
        add_action('admin_enqueue_scripts', array($this, 'enqueue_admin_assets'));
    }

    public function add_menu_page() {
        add_options_page(
            'MeowPWA 设置',
            'MeowPWA',
            'manage_options',
            'meowpwa-settings',
            array($this, 'render_settings_page')
        );
    }

    public function register_settings() {
        register_setting('meowpwa_settings_group', 'meowpwa_settings');
    }

    public function enqueue_admin_assets($hook) {
        if ('settings_page_meowpwa-settings' !== $hook) {
            return;
        }
        wp_enqueue_media();
        wp_enqueue_script('meowpwa-admin-js', MEOWPWA_URL . 'assets/js/admin.js', array('jquery'), '1.0.0', true);
    }

    public function render_settings_page() {
        $settings = get_option('meowpwa_settings', array());
        ?>
        <div class="wrap">
            <h1>MeowPWA 设置</h1>
            <form method="post" action="options.php">
                <?php settings_fields('meowpwa_settings_group'); ?>
                <table class="form-table">
                    <tr>
                        <th scope="row">应用名称</th>
                        <td><input type="text" name="meowpwa_settings[name]" value="<?php echo esc_attr($settings['name'] ?? get_bloginfo('name')); ?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th scope="row">简短名称</th>
                        <td><input type="text" name="meowpwa_settings[short_name]" value="<?php echo esc_attr($settings['short_name'] ?? get_bloginfo('name')); ?>" class="regular-text"></td>
                    </tr>
                    <tr>
                        <th scope="row">描述</th>
                        <td><textarea name="meowpwa_settings[description]" class="regular-text"><?php echo esc_textarea($settings['description'] ?? get_bloginfo('description')); ?></textarea></td>
                    </tr>
                    <tr>
                        <th scope="row">主题颜色</th>
                        <td><input type="color" name="meowpwa_settings[theme_color]" value="<?php echo esc_attr($settings['theme_color'] ?? '#ffffff'); ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row">背景颜色</th>
                        <td><input type="color" name="meowpwa_settings[background_color]" value="<?php echo esc_attr($settings['background_color'] ?? '#ffffff'); ?>"></td>
                    </tr>
                    <tr>
                        <th scope="row">应用图标 (512x512)</th>
                        <td>
                            <input type="hidden" id="meowpwa_icon_id" name="meowpwa_settings[icon_id]" value="<?php echo esc_attr($settings['icon_id'] ?? ''); ?>">
                            <div id="meowpwa_icon_preview" style="margin-bottom: 10px;">
                                <?php if (!empty($settings['icon_id'])): ?>
                                    <?php echo wp_get_attachment_image($settings['icon_id'], 'thumbnail'); ?>
                                <?php endif; ?>
                            </div>
                            <button type="button" class="button" id="meowpwa_upload_btn">选择图标</button>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row">离线页面</th>
                        <td>
                            <?php
                            wp_dropdown_pages(array(
                                'name' => 'meowpwa_settings[offline_page]',
                                'selected' => $settings['offline_page'] ?? 0,
                                'show_option_none' => '默认 (离线提示)',
                            ));
                            ?>
                        </td>
                    </tr>
                </table>
                <?php submit_button(); ?>
            </form>
        </div>
        <?php
    }
}
