if ('serviceWorker' in navigator) {
    window.addEventListener('load', function() {
        navigator.serviceWorker.register(meowpwa_vars.sw_url).then(function(registration) {
            console.log('MeowPWA ServiceWorker registered: ', registration.scope);
        }, function(err) {
            console.log('MeowPWA ServiceWorker registration failed: ', err);
        });
    });
}

// 处理 Android "添加到主屏幕" 提示
let deferredPrompt;
window.addEventListener('beforeinstallprompt', (e) => {
    // 阻止 Chrome 67 及更早版本自动显示提示
    e.preventDefault();
    // 暂存事件以便稍后触发
    deferredPrompt = e;
    // 这里可以显示自定义的安装按钮，但通常 Android 会在满足条件时自动处理
    // 如果需要强制弹出，可以调用 deferredPrompt.prompt()
});

// 处理 iOS Safari 提示
function isIos() {
    const userAgent = window.navigator.userAgent.toLowerCase();
    return /iphone|ipad|ipod/.test(userAgent);
}

function isInStandaloneMode() {
    return ('standalone' in window.navigator) && (window.navigator.standalone);
}

if (isIos() && !isInStandaloneMode()) {
    window.addEventListener('load', () => {
        const lastPrompt = localStorage.getItem('meowpwa_ios_prompt');
        const now = new Date().getTime();
        
        // 7天提示一次，避免骚扰
        if (!lastPrompt || (now - lastPrompt) > 7 * 24 * 60 * 60 * 1000) {
            showIosInstallPrompt();
        }
    });
}

function showIosInstallPrompt() {
    const prompt = document.createElement('div');
    prompt.className = 'meowpwa-ios-prompt';
    prompt.innerHTML = `
        <div class="meowpwa-ios-content">
            <p>想要更方便地访问吗？</p>
            <p>点击浏览器底部的 <span class="meowpwa-icon-share"></span> 按钮，然后选择<strong>“添加到主屏幕”</strong>。</p>
            <button id="meowpwa-close-prompt">知道了</button>
        </div>
    `;
    document.body.appendChild(prompt);
    
    document.getElementById('meowpwa-close-prompt').addEventListener('click', () => {
        prompt.remove();
        localStorage.setItem('meowpwa_ios_prompt', new Date().getTime());
    });
}
